package w83b.w83bOperacionesPaso.w83bImpugnaciones;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import w83b.w83bBeans.W83bDocBeanImpug;
import w83b.w83bBeans.W83bHistorialImpugnacionBean;
import w83b.w83bBeans.W83bImpugnacionBean;
import w83b.w83bBeans.W83bTramiteImpugnacionBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;

import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bDetallesImpugnacionOutOPAction extends Q70ActionPasoOP{

	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		//Guardamos la accion en el contexto
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		HashMap mapa = (HashMap)contexto.get("w83bMapaImpugnaciones");
		if ("0".equals(mapa.get("pestania")))
		{
			W83bImpugnacionBean impug=(W83bImpugnacionBean)contexto.get("w83bNuevaImpugnacionBean");
			contexto.set("w83bprovincia", impug.getCentroTrabajo().getCodTerritorio());
			contexto.set("w83bmunicipio", impug.getCentroTrabajo().getCodMunicipio());
			contexto.set("w83bprovinciaImpug", impug.getProvinciaImpug());
			contexto.set("w83bmunicipioImpug", impug.getMunicipioImpug());
			
			W83bUsuarioXLNetsBean usuario= (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
			contexto.set("w83bPerfilUsuario", W83bUtilidadesN38API.elegirAdministradorConsulta(usuario.getPerfilXLNets()));
			contexto.set("w83bCodTerritUsuario", W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets()));
			contexto.set("w83bRegManual", usuario.getRegManual());
			contexto.set("w83bModelo", usuario.getModelo());
			return mapping.findForward("paginaDetalles");
		}
		else
		{
			JSONObject resultado = new JSONObject ();
			
			if ("1".equals(mapa.get("pestania")))
				{
					//docs adjuntos
					W83bImpugnacionBean impug=(W83bImpugnacionBean)contexto.get("w83bNuevaImpugnacionBean");
					JSONArray listaDocs=new JSONArray();
					JSONObject docJSON=null;
					W83bDocBeanImpug doc=null;
					for (int i=0;i<impug.getListaDocs().size();i++)
					{
						doc=(W83bDocBeanImpug)impug.getListaDocs().get(i);
						docJSON=new JSONObject();//NOPMD
						docJSON.put("nombreDoc", doc.getNombrePartido());
						docJSON.put("tipoDoc", doc.getDescTipo());
						docJSON.put("idDoc", doc.getId());
						if(StringUtils.isNotEmpty(doc.getNumeroRegistro())){
							docJSON.put("numRegistro", (doc.getNumeroRegistro().length()>8)? doc.getNumeroRegistro().substring(0, 8) + " " + doc.getNumeroRegistro().substring(8, doc.getNumeroRegistro().length()):doc.getNumeroRegistro());
						}else{
							docJSON.put("numRegistro","");
						}
						docJSON.put("fechaRegistro", doc.getFechaRegistro());
						docJSON.put("codTramite", doc.getCodTramite());
						docJSON.put("descTramite", doc.getDescTramite());
						docJSON.put("deseTramite", doc.getDeseTramite());
						docJSON.put("usuario", doc.getUsuario());
						docJSON.put("codRemesaAcuse", StringUtils.isNotEmpty(doc.getCodRemesaAcuse())?doc.getCodRemesaAcuse():"");
						docJSON.put("codColeccionAcuse", StringUtils.isNotEmpty(doc.getCodColeccionAcuse())?doc.getCodColeccionAcuse():"");
						docJSON.put("codEnvioAcuse",StringUtils.isNotEmpty(doc.getCodEnvioAcuse())?doc.getCodEnvioAcuse():"");
						listaDocs.put(docJSON);

					}
					resultado.put("listaDocs",listaDocs);
					
					resultado.put("resultado", "ok");
					response.setContentType("text/javascript;charset=iso-8859-1");
					response.setHeader("Pragma", "cache");
					response.setHeader("Expires", "0");
					response.setHeader("Cache-Control", "private");
					response.setStatus(HttpServletResponse.SC_OK);
					PrintWriter out = response.getWriter();
					out.print(resultado.toString());
					out.flush();
					
					return null;

				}
				
					else
						if ("2".equals(mapa.get("pestania")))
						{
							String idioma=(String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
							
							if ("1".equals(mapa.get("grid")))
							{
								//historial	
								W83bImpugnacionBean impug=(W83bImpugnacionBean)contexto.get("w83bNuevaImpugnacionBean");
								W83bHistorialImpugnacionBean historialImpugBean=new W83bHistorialImpugnacionBean();
								historialImpugBean = (W83bHistorialImpugnacionBean)W83bUtilidadesComunes.inicializarPaginador(request, historialImpugBean);
								int num_paginas = (impug.getListaHistorial().size()/Integer.parseInt(historialImpugBean.getTotal()));
								
								
								if(impug.getListaHistorial().size()%Integer.parseInt(historialImpugBean.getTotal())>0){
									num_paginas++;
								}
								
								historialImpugBean.setRows(String.valueOf(num_paginas));
							
								
								List listaVariables = new ArrayList();
								
								listaVariables.add("dia_actuacion");
								listaVariables.add("hora_actuacion");
								if(idioma.equals(W83bClsConstantes.CONSTANTE_EUSKARA))
								{
									listaVariables.add("descripcionE");
								}else{
									listaVariables.add("descripcionC");
								}
								
								listaVariables.add("usuario");
								
								
								String varClave = "dia_actuacion";
								
								
								String jJson = W83bUtilidadesComunes.procesarTablaConId(impug.getListaHistorial(),listaVariables,varClave,W83bHistorialImpugnacionBean.class, historialImpugBean);
								
								response.setContentType("text/javascript;charset=iso-8859-1");
								response.setHeader("Pragma", "cache");
								response.setHeader("Expires", "0");
								response.setHeader("Cache-Control", "private");
								response.setStatus(HttpServletResponse.SC_OK);
								PrintWriter out = response.getWriter();
								out.print(jJson);
								out.flush();

							}else
							{
								//tramites
								W83bImpugnacionBean impug=(W83bImpugnacionBean)contexto.get("w83bNuevaImpugnacionBean");
								W83bTramiteImpugnacionBean tramiteBean=new W83bTramiteImpugnacionBean();
								tramiteBean = (W83bTramiteImpugnacionBean)W83bUtilidadesComunes.inicializarPaginador(request, tramiteBean);
								int num_paginas = (impug.getListaTramites().size()/Integer.parseInt(tramiteBean.getTotal()));
								
								
								if(impug.getListaTramites().size()%Integer.parseInt(tramiteBean.getTotal())>0){
									num_paginas++;
								}
								tramiteBean.setRows(String.valueOf(num_paginas));
								
								List listaVariables = new ArrayList();
								
								
								if(idioma.equals(W83bClsConstantes.CONSTANTE_EUSKARA))
								{
									listaVariables.add("dese_fase");
									listaVariables.add("dese_tramite");
								}else{
									listaVariables.add("desc_fase");
									listaVariables.add("desc_tramite");
								}
								
								
								listaVariables.add("fecha_tramite");
								listaVariables.add("usuario_alta");
								listaVariables.add("fecha_alta");
								listaVariables.add("usuario_modif");
								listaVariables.add("fecha_modif");

								
								String varClave = "fecha_alta";
								
								
								String jJson = W83bUtilidadesComunes.procesarTablaConId(impug.getListaTramites(),listaVariables,varClave,W83bTramiteImpugnacionBean.class, tramiteBean);
								
								response.setContentType("text/javascript;charset=iso-8859-1");
								response.setHeader("Pragma", "cache");
								response.setHeader("Expires", "0");
								response.setHeader("Cache-Control", "private");
								response.setStatus(HttpServletResponse.SC_OK);
								PrintWriter out = response.getWriter();
								out.print(jJson);
								out.flush();
							}
							
							
						}
			return null;
		}
		
	}
}
